<?php
error_reporting(0);
ini_set('display_errors', 0);

/*
 * 🔒 @ Atualização de Credenciais 
 * 🚀 @ Versão: 1.0.2
 * 📅 @ Atualizado: <?= date('d/m/Y') ?>
 */

include "includes/header.php";
$table_name = "users";
$res = $db->select($table_name, "*", "", "");

$successMessage = "";

if (isset($_POST["submit"])) {
    unset($_POST["submit"]);

    if (empty($_POST["username"]) || empty($_POST["password"])) {
        echo '<div class="alert alert-danger">⚠️ Por favor, preencha todos os campos!</div>';
    } else {
        $updateData = $_POST;
        $db->update($table_name, $updateData, "id = :id", [":id" => 1]);
        session_regenerate_id();
        $_SESSION["loggedin"] = true;
        $_SESSION["name"] = $_POST["username"];
        $successMessage = "✅ Credenciais atualizadas com sucesso!";
    }
}
?>

<style>
    body {
        background: #121212;
        color: #e0e0e0;
        font-family: 'Segoe UI', Roboto, sans-serif;
        margin: 0;
        padding: 0;
    }

    .container {
        padding-left: 15px;
        padding-right: 15px;
        width: 100%;
        max-width: 1140px;
        margin-left: auto;
        margin-right: auto;
    }

    .credentials-card {
        border-radius: 16px;
        background: #1e1e2f;
        box-shadow: 0 8px 30px rgba(0, 0, 0, 0.3);
        border: 1px solid #2a2a3d;
        animation: fadeInUp 0.5s ease;
        position: relative;
        padding: 20px 30px;
        box-sizing: border-box;
    }

    .card-header-warning {
        background: linear-gradient(135deg, #4f46e5, #3f3cbb);
        border-radius: 16px 16px 0 0 !important;
        padding: 20px;
        color: #fff;
        text-align: center;
    }

    h2 {
        margin: 0;
        font-weight: 600;
        font-size: 1.5rem;
    }

    .form-label {
        font-weight: 600;
        margin-bottom: 5px;
        color: #cfd8dc;
    }

    .form-control {
        background-color: #292c3e;
        border: 2px solid #3a3f57;
        color: #ffffff;
        border-radius: 10px;
        padding: 12px;
        transition: all 0.3s ease-in-out;
        width: 100%;
        box-sizing: border-box;
    }

    .form-control:focus {
        border-color: #4f46e5;
        box-shadow: 0 0 0 3px rgba(79, 70, 229, 0.25);
        outline: none;
    }

    .btn-update {
        background: linear-gradient(135deg, #4f46e5, #3b3bb5);
        color: #fff;
        border: none;
        border-radius: 50px;
        padding: 14px 32px;
        font-weight: bold;
        font-size: 15px;
        letter-spacing: 0.5px;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 14px rgba(79, 70, 229, 0.3);
        position: relative;
        overflow: hidden;
        width: 100%;
        box-sizing: border-box;
    }

    .btn-update:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(79, 70, 229, 0.45);
    }

    hr {
        border-top: 1px solid #444;
    }

    @keyframes fadeInUp {
        from {
            transform: translateY(40px);
            opacity: 0;
        }
        to {
            transform: translateY(0);
            opacity: 1;
        }
    }

    .alert-success-custom {
        background: rgba(46, 125, 50, 0.2);
        border: 1px solid #4caf50;
        color: #c8e6c9;
        padding: 12px 20px;
        border-radius: 12px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 10px;
        animation: fadeInUp 0.5s ease;
        margin-bottom: 20px;
        position: relative;
    }

    .alert-success-custom i {
        color: #81c784;
        font-size: 20px;
    }

    .fade-out {
        opacity: 0;
        transition: opacity 0.6s ease;
    }

    /* Layout container e coluna */
    .col-lg-6, .col-md-8, .col-sm-10 {
        width: 100%;
        max-width: 600px;
        margin-left: auto;
        margin-right: auto;
    }

    /* Responsividade para tablets */
    @media (max-width: 768px) {
        .credentials-card {
            padding: 15px 20px;
            border-radius: 12px;
        }
        .card-header-warning {
            padding: 15px 10px;
            font-size: 1rem;
        }
        h2 {
            font-size: 1.25rem;
        }
        .form-label {
            font-size: 0.9rem;
        }
        .form-control {
            padding: 10px;
            font-size: 0.9rem;
        }
        .btn-update {
            padding: 12px 25px;
            font-size: 14px;
        }
    }

    /* Responsividade para mobile pequenos */
    @media (max-width: 480px) {
        .credentials-card {
            padding: 10px 15px;
            border-radius: 10px;
        }
        h2 {
            font-size: 1.1rem;
        }
        .form-label {
            font-size: 0.85rem;
        }
        .form-control {
            padding: 8px;
            font-size: 0.85rem;
        }
        .btn-update {
            padding: 10px 20px;
            font-size: 13px;
        }
    }
</style>

<div class="container py-5">
    <div class="col-lg-6 col-md-8 col-sm-10 mx-auto">
        <div class="card credentials-card">
            <div class="card-header card-header-warning">
                <h2><i class="fas fa-user-shield"></i> 🔒 Mantenha o admin como nome de usuário ou senha</h2>
            </div>

            <div class="card-body px-4 py-4">
                <?php if (!empty($successMessage)): ?>
                    <div id="successMessage" class="alert-success-custom">
                        <i class="fas fa-check-circle"></i>
                        <?= $successMessage ?>
                    </div>
                    <script>
                        setTimeout(() => {
                            const alert = document.getElementById('successMessage');
                            if (alert) {
                                alert.classList.add('fade-out');
                                setTimeout(() => alert.remove(), 600);
                            }
                        }, 3000);
                    </script>
                <?php endif; ?>

                <form method="post" novalidate>
                    <div class="form-group mb-4">
                        <label class="form-label"><i class="fas fa-user"></i> Nome de Usuário</label>
                        <input type="text" class="form-control" name="username" value="<?= htmlspecialchars($res[0]["username"]) ?>" placeholder="Digite um nome de usuário seguro" required>
                    </div>

                    <div class="form-group mb-3">
                        <label class="form-label"><i class="fas fa-lock"></i> Senha</label>
                        <input type="password" class="form-control" name="password" value="<?= htmlspecialchars($res[0]["password"]) ?>" placeholder="Digite uma senha segura" required>
                        <small class="form-text text-muted">Recomendamos usar letras, números e caracteres especiais</small>
                    </div>

                    <hr class="my-4">

                    <div class="text-center">
                        <button type="submit" name="submit" class="btn btn-update">
                            <i class="fas fa-save"></i> 💾 Atualizar Credenciais
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include "includes/footer.php"; ?>
