<?php
// Verificar se o formulário foi enviado via POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: texto.php');
    exit();
}

// Verificar se o texto foi enviado
if (!isset($_POST['text']) || empty(trim($_POST['text']))) {
    header('Location: texto.php?error=empty');
    exit();
}

$text = trim($_POST['text']);

// Verificar limite de caracteres
if (strlen($text) > 71) {
    header('Location: texto.php?error=limit');
    exit();
}

try {
    // Configurações da imagem - similar ao design mostrado
    $width = 800;
    $height = 400;
    
    // Criar uma nova imagem
    $image = imagecreatetruecolor($width, $height);
    
    // Criar gradiente escuro (similar ao design da captura)
    for ($y = 0; $y < $height; $y++) {
        $ratio = $y / $height;
        
        // Gradiente de verde escuro para preto
        $r = (int)(20 * (1 - $ratio) + 10 * $ratio);
        $g = (int)(40 * (1 - $ratio) + 20 * $ratio);
        $b = (int)(30 * (1 - $ratio) + 15 * $ratio);
        
        $color = imagecolorallocate($image, $r, $g, $b);
        imageline($image, 0, $y, $width, $y, $color);
    }
    
    // Adicionar borda verde/ciano
    $border_color = imagecolorallocate($image, 0, 255, 200); // Verde/ciano
    $border_thickness = 3;
    
    for ($i = 0; $i < $border_thickness; $i++) {
        imagerectangle($image, $i, $i, $width - 1 - $i, $height - 1 - $i, $border_color);
    }
    
    // Cores para o texto
    $white = imagecolorallocate($image, 255, 255, 255);
    $yellow = imagecolorallocate($image, 255, 255, 0);
    $green = imagecolorallocate($image, 0, 255, 150);
    
    // Verificar fontes disponíveis
    $font_paths = [
        '/System/Library/Fonts/Arial.ttf',
        '/usr/share/fonts/truetype/dejavu/DejaVuSans.ttf',
        'C:\\Windows\\Fonts\\arial.ttf',
        './fonts/arial.ttf',
        './arial.ttf'
    ];
    
    $font_file = null;
    foreach ($font_paths as $path) {
        if (file_exists($path)) {
            $font_file = $path;
            break;
        }
    }
    
    if ($font_file && function_exists('imagettftext')) {
        // Adicionar título decorativo no topo
        $title = "📱 Mensagem Personalizada 📱";
        $title_size = 16;
        $title_box = imagettfbbox($title_size, 0, $font_file, $title);
        $title_width = $title_box[4] - $title_box[0];
        $title_x = ($width - $title_width) / 2;
        $title_y = 50;
        
        // Sombra do título
        imagettftext($image, $title_size, 0, $title_x + 2, $title_y + 2, imagecolorallocate($image, 0, 0, 0), $font_file, $title);
        // Título principal
        imagettftext($image, $title_size, 0, $title_x, $title_y, $yellow, $font_file, $title);
        
        // Texto principal do usuário
        $main_size = 20;
        
        // Quebrar texto em linhas se necessário
        $max_chars_per_line = 35;
        $lines = [];
        if (strlen($text) > $max_chars_per_line) {
            $words = explode(' ', $text);
            $current_line = '';
            
            foreach ($words as $word) {
                if (strlen($current_line . ' ' . $word) <= $max_chars_per_line) {
                    $current_line .= ($current_line ? ' ' : '') . $word;
                } else {
                    if ($current_line) $lines[] = $current_line;
                    $current_line = $word;
                }
            }
            if ($current_line) $lines[] = $current_line;
        } else {
            $lines = [$text];
        }
        
        $line_height = 30;
        $total_text_height = count($lines) * $line_height;
        $start_y = ($height - $total_text_height) / 2 + 40;
        
        foreach ($lines as $i => $line) {
            $text_box = imagettfbbox($main_size, 0, $font_file, $line);
            $text_width = $text_box[4] - $text_box[0];
            $x = ($width - $text_width) / 2;
            $y = $start_y + ($i * $line_height);
            
            // Sombra do texto
            imagettftext($image, $main_size, 0, $x + 2, $y + 2, imagecolorallocate($image, 0, 0, 0), $font_file, $line);
            // Texto principal
            imagettftext($image, $main_size, 0, $x, $y, $white, $font_file, $line);
        }
        
        // Adicionar rodapé
        $footer = "suporte: maxloja.xyz";
        $footer_size = 12;
        $footer_box = imagettfbbox($footer_size, 0, $font_file, $footer);
        $footer_width = $footer_box[4] - $footer_box[0];
        $footer_x = ($width - $footer_width) / 2;
        $footer_y = $height - 30;
        
        imagettftext($image, $footer_size, 0, $footer_x, $footer_y, $green, $font_file, $footer);
        
    } else {
        // Fallback para fontes built-in
        $title = "Mensagem Personalizada";
        $title_width = imagefontwidth(4) * strlen($title);
        $title_x = ($width - $title_width) / 2;
        imagestring($image, 4, $title_x, 30, $title, $yellow);
        
        // Texto principal
        $font_size = 5;
        $max_chars = 50;
        $lines = str_split($text, $max_chars);
        
        $line_height = 20;
        $total_height = count($lines) * $line_height;
        $start_y = ($height - $total_height) / 2;
        
        foreach ($lines as $i => $line) {
            $text_width = imagefontwidth($font_size) * strlen($line);
            $x = ($width - $text_width) / 2;
            $y = $start_y + ($i * $line_height);
            
            imagestring($image, $font_size, $x + 1, $y + 1, $line, imagecolorallocate($image, 0, 0, 0));
            imagestring($image, $font_size, $x, $y, $line, $white);
        }
        
        // Rodapé
        $footer = "suporte: maxloja.xyz";
        $footer_width = imagefontwidth(2) * strlen($footer);
        $footer_x = ($width - $footer_width) / 2;
        imagestring($image, 2, $footer_x, $height - 25, $footer, $green);
    }
    
    // Adicionar alguns elementos decorativos
    $accent_color = imagecolorallocate($image, 0, 255, 200);
    
    // Linhas decorativas
    imageline($image, 50, 80, $width - 50, 80, $accent_color);
    imageline($image, 50, $height - 60, $width - 50, $height - 60, $accent_color);
    
    // Criar diretório se não existir
    $upload_dir = 'rtx/';
    if (!file_exists($upload_dir)) {
        mkdir($upload_dir, 0777, true);
    }
    
    // Substituir a imagem de cabeçalho existente ou criar nova
    $filename = 'imgtexto.png'; // Nome fixo para substituir a imagem do cabeçalho
    $filepath = $upload_dir . $filename;
    
    // Salvar a imagem
    imagepng($image, $filepath, 9);
    
    // Também salvar uma cópia com timestamp para histórico
    $backup_filename = 'texto_' . date('Y-m-d_H-i-s') . '.png';
    imagepng($image, $upload_dir . $backup_filename, 9);
    
    // Limpar memória
    imagedestroy($image);
    
    // Log da operação
    $log_entry = date('[Y-m-d H:i:s] ') . "Imagem atualizada - Texto: \"$text\"\n";
    file_put_contents($upload_dir . 'log.txt', $log_entry, FILE_APPEND | LOCK_EX);
    
    // Redirecionar com sucesso
    header('Location: texto.php?success=1');
    exit();
    
} catch (Exception $e) {
    error_log('Erro ao gerar imagem: ' . $e->getMessage());
    header('Location: texto.php?error=generate');
    exit();
}
?>