<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Movie Banner</title>
  <style>
    :root {
      --overlay-color: rgba(0, 0, 0, 0.6);
      --text-color: #fff;
      --transition-speed: 1s;
    }

    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }

    html, body {
      width: 100%;
      height: 100%;
      font-family: 'Segoe UI', sans-serif;
      background: #0e0e1a;
      overflow: hidden;
    }

    .banner-container {
      position: relative;
      width: 100%;
      height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
      overflow: hidden;
    }

    .movie-poster {
      position: absolute;
      width: 100%;
      height: 100%;
      object-fit: cover;
      opacity: 0;
      transition: opacity var(--transition-speed) ease-in-out;
      z-index: 0;
    }

    .movie-poster.active {
      opacity: 1;
      z-index: 1;
    }

    .overlay {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: var(--overlay-color);
      z-index: 2;
    }

    .movie-title {
      position: absolute;
      bottom: 40px;
      left: 40px;
      color: var(--text-color);
      font-size: 2.5rem;
      z-index: 3;
      text-shadow: 0 2px 10px rgba(0,0,0,0.7);
      max-width: 90%;
    }

    @media (max-width: 768px) {
      .movie-title {
        font-size: 1.5rem;
        left: 20px;
        bottom: 20px;
      }
    }
  </style>
</head>
<body>
  <div class="banner-container" id="movie-banner">
    <div class="overlay"></div>
    <div class="movie-title" id="movie-title">Carregando...</div>
  </div>

  <script>
    const apiKey = '6b8e3eaa1a03ebb45642e9531d8a76d2';
    let movieIds = [];
    let currentPosterIndex = 0;

    async function fetchPopularMovieIds() {
      try {
        const response = await fetch(`https://api.themoviedb.org/3/discover/movie?api_key=${apiKey}&sort_by=popularity.desc&language=pt-BR`);
        const data = await response.json();
        movieIds = data.results.map(movie => movie.id);
      } catch (error) {
        console.error('Erro ao buscar filmes populares:', error);
      }
    }

    async function updateMovieBanner() {
      if (movieIds.length === 0) return;

      const movieId = movieIds[currentPosterIndex];
      try {
        const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}?api_key=${apiKey}&language=pt-BR`);
        const data = await response.json();

        const movieBanner = document.getElementById('movie-banner');
        const movieTitle = document.getElementById('movie-title');

        const posterPath = `https://image.tmdb.org/t/p/original${data.backdrop_path || data.poster_path}`;
        const moviePoster = document.createElement('img');
        moviePoster.src = posterPath;
        moviePoster.alt = data.title;
        moviePoster.className = 'movie-poster';

        moviePoster.onload = () => {
          const oldPosters = document.querySelectorAll('.movie-poster');
          oldPosters.forEach(poster => poster.classList.remove('active'));
          movieBanner.appendChild(moviePoster);
          setTimeout(() => moviePoster.classList.add('active'), 50);

          if (oldPosters.length > 0) {
            setTimeout(() => oldPosters[0].remove(), 1000); // Remove suavemente o anterior
          }

          movieTitle.textContent = data.title;
        };

        currentPosterIndex = (currentPosterIndex + 1) % movieIds.length;
      } catch (error) {
        console.error('Erro ao carregar pôster:', error);
      }
    }

    fetchPopularMovieIds().then(() => {
      updateMovieBanner();
      setInterval(updateMovieBanner, 8000); // tempo entre mudanças (8s)
    });
  </script>
</body>
</html>
